// Input.js //

function Input(x, y, w, h, style)
{
	if (this instanceof Input == false)
	{
		return new Input();
	}
	
	this.x = x; this.y = y; this.w = w; this.h = h;
	this.txt         = "";
	this.style       = style || new Style();
	this.onEnter     = function(){};
	this.onEscape    = function(){};
	this.preText     = "";
	this.overflow    = false;
	this.useWindow   = false;
	this.totalLength = this.style.font.getStringWidth(this.preText);
	this.active      = true;
	this.done        = false;
}

Input.prototype.update = function()
{
	while(AreKeysLeft() && !IsKeyPressed(KEY_TAB))
	{
		var Key = GetKey();
		switch (Key)
		{
			case KEY_ENTER: this.done = true; this.onEnter(); break;
			case KEY_ESCAPE: this.done = true; this.onEscape(); break;
			case KEY_BACKSPACE: if (this.txt.length > 0) this.txt = this.txt.substr(0, this.txt.length-1);
			default:
				var STW = this.style.font.getStringWidth(this.txt);
				var PTW = this.style.font.getStringWidth(this.preText);
				if (STW < this.w-PTW-8 || this.overflow)
				{
					Shift = IsKeyPressed(KEY_SHIFT);
					Typed = GetKeyString(Key, Shift);
					if (Typed != "") this.txt += Typed;
				}
			break; 
		}
	}
}

Input.prototype.drawText = function()
{
	this.totalLength = this.style.font.getStringWidth(this.preText + this.txt);
	var date = new Date();

	if (this.useWindow)
		this.style.window.drawWindow(this.x, this.y, this.w, this.h);

	this.style.drawText(this.x+4, this.y+2, this.preText + this.txt);

	if (date.getMilliseconds() > 500)
		this.style.drawText(this.x+this.totalLength+4, this.y+2, "|");
}

Input.prototype.blit = function()
{
	if (this.active)
	{
		this.drawText();
		this.update();
	}
	else this.font.drawText(this.x, this.y, this.preText + this.txt); 
}

Input.prototype.setActive = function(bool)
{
	this.active = bool;
	ClearKeyQueue();
}

KeyStates = [];
for (var i = 1; i < 90; ++i) KeyStates[i] = {key: i, state: false, time: 0}
function KeyPress(key)
{
	if (IsKeyPressed(key) && !KeyStates[key].state)
	{
		KeyStates[key].state = true;
		KeyStates[key].time = GetTime();
		return true;
	}
	return false;
}

function AnyKeyPress()
{
	if (!IsAnyKeyPressed())
	{
		var key = GetKey();
		KeyStates[key].state = true;
		KeyStates[key].time = GetTime();
		return true;
	}
	return false;
}

function GetKeyState(key)
{
  return KeyStates[key].state;
}

function CheckKeyStates()
{
	for (var i = 1; i < 90; ++i)
	{
		if (!IsKeyPressed(i)) KeyStates[i].state = false;
		else if (KeyStates[i].time + 150 < GetTime()) KeyStates[i].state = false;
	}
}